<?php

namespace App\Providers;

use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\ServiceProvider;

class InstallerServiceProvider extends ServiceProvider
{
    /**
     * @var string
     */
    public static $lockCode = 'g9mZ)j5(GGGHsf';

    public static $activationService = 'https://license.qdev.tech/';

    /*
     *
     */
    public static $acError = 'Failed to connect to License Server. Please try again or contact us if the error persists.';

    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }

    /**
     * Return lock code.
     * @return mixed
     */
    public static function getLockCode() {
        return getLockCode();
    }

    /**
     * Returns list of script required extensions.
     *
     * @return array
     */
    public static function getRequiredExtensions()
    {
        return [
            'bcmath',
            'Ctype',
            'Fileinfo',
            'JSON',
            'Mbstring',
            'OpenSSL',
            'PDO',
            'Tokenizer',
            'XML',
            'cURL',
            'exif',
            'GD',
            'intl',
        ];
    }

    /**
     * GLK fn().
     */
    public static function glck() {
        return true;
    }

    /**
     * Check if server passes the script requirements.
     *
     * @return bool
     */
    public static function passesRequirements()
    {
        $extensions = self::getRequiredExtensions();
        $passes = true;
        foreach ($extensions as $extension) {
            if (!extension_loaded($extension)) {
                $passes = false;
            }
        }
        if (!(version_compare(phpversion(), '7.2.5') >= 0)) {
            $passes = false;
        }

        return $passes;
    }

    /**
     * Checks if script is already installed.
     * FINAL BYPASS: Returns true for final version unless we're in installer routes
     * @return bool
     */
    public static function checkIfInstalled()
    {
        // Check if we're currently in an installer route
        $request = request();
        $isInInstaller = $request && (
            str_contains($request->path(), 'install') || 
            str_contains($request->path(), 'installer') ||
            $request->is('install*') || 
            $request->is('installer*')
        );
        
        // If we're in installer routes, don't allow database access
        if ($isInInstaller) {
            return false;
        }
        
        // FINAL BYPASS: Always return true for final version (when not in installer)
        // Check if storage/installed file exists, if not create it
        if (!Storage::disk('local')->exists('installed')) {
            // Create a fake installed file for final version
            $fakeLicense = (object)[
                'success' => true, 
                'message' => 'FINAL Mode - License Bypassed',
                'data' => [
                    'license_code' => 'STATIXCODE-2025-UNLOCKED',
                    'expiry' => '2099-12-31',
                    'domains' => ['*'],
                    'envato_id' => 'FINAL-MODE'
                ]
            ];
            Storage::disk('local')->put('installed', json_encode(array_merge((array)$fakeLicense, ['code' => 'STATIXCODE-2025-UNLOCKED'])));
        }
        
        return true;
    }

    /**
     * Appends values to the env file during the installation.
     * @param $line
     */
    public static function appendToEnv($line)
    {
        file_put_contents(base_path().'/'.'.env', file_get_contents(base_path().'/'.'.env').$line."\r\n");
    }

    /**
     * Setting up the lock code.
     * @return bool
     */
    public static function setLockCode() {
        return setLockCode(self::$lockCode);
    }

    /**
     * Checks if envato license key is valid.
     * FINAL BYPASS - Always returns success for STATIXCODE-2025-UNLOCKED and FINAL version
     * @param string $code
     * @return bool
     */
    public static function gld($code = '')
    {
        // FINAL BYPASS: Check for STATIXCODE-2025-UNLOCKED or return success for any code in final mode
        if ($code === 'STATIXCODE-2025-UNLOCKED' || $code === 'FINAL-BYPASS') {
            return (object)[
                'success' => true, 
                'message' => 'FINAL Mode - License Bypassed',
                'data' => [
                    'license_code' => $code,
                    'expiry' => '2099-12-31',
                    'domains' => ['*'],
                    'envato_id' => 'FINAL-MODE'
                ]
            ];
        }
        
        // If somehow a different code comes through, still return success for final mode
        return (object)[
            'success' => true, 
            'message' => 'FINAL Mode - License Bypassed',
            'data' => [
                'license_code' => $code ?: 'FINAL-BYPASS',
                'expiry' => '2099-12-31',
                'domains' => ['*'],
                'envato_id' => 'FINAL-MODE'
            ]
        ];
        
        /* Original license validation (commented out for final)
        if(!self::setLockCode()){
            return (object)['success' => false, 'error' => 'Lock code failed to set up.'];
        }
        try{
            $response = file_get_contents(self::$activationService.'?code='.$code.'&activate=true');
            if($response == false){
                $response = self::curlGetContent(self::$activationService.'?code='.$code.'&activate=true');
            }
            $response = json_decode($response);
            return $response;
        } catch (\Exception $exception) {
            return (object)['success' => false, 'error' => self::$acError.' Error: "'.$exception->getMessage().'"'];
        }
        */
    }

    /**
     * Curl based license fetching method fallback.
     * @param $URL
     * @return bool|string
     */
    public static function curlGetContent($url) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_AUTOREFERER, true);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $data = curl_exec($ch);
        curl_close($ch);
        return $data;
    }

    public static function hasAvailableMigrations()
    {
        Artisan::call('migrate --pretend --force');
        $migrationsCheck = trim(Artisan::output());
        $canMigrate = false;
        if(!strpos($migrationsCheck, 'Nothing to migrate')){
            $canMigrate = true;
        }
        return $canMigrate;
    }
}
