<?php
    $licensePath = storage_path('app/installed');
    $license = null;

    if (file_exists($licensePath)) {
        $contents = file_get_contents($licensePath);
        $json = json_decode($contents, true);

        if (json_last_error() === JSON_ERROR_NONE && isset($json['data']) && is_array($json['data'])) {
            $license = $json['data'];
            $license['code'] = $json['code'] ?? null;
        }
    }
?>

<?php if($license): ?>
    <div class="alert-info alert relative flex justify-between items-start gap-4 mb-4">
        <div class="flex gap-3 pr-4">
            <div class="d-flex v-align-center mb-1">
                <?php if (isset($component)) { $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c = $attributes; } ?>
<?php $component = BladeUI\Icons\Components\Svg::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('heroicon-o-information-circle'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\BladeUI\Icons\Components\Svg::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-5 h-5 icon text-yellow-600 mt-1']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $attributes = $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $component = $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
                <p class="font-semibold text-yellow-800 dark:text-yellow-300 ml-1 mb-0">
                    License Details
                </p>
            </div>
            <div class="space-y-2">

                <ul class="list-disc list-inside text-sm space-y-1 mb-0">
                    <li><strong>Item:</strong> <?php echo e($license['item'] ?? 'JustFans v9.3.1'); ?></li>
                    <li><strong>License:</strong> <?php echo e($license['license'] ?? 'STATIXCODE-2025-UNLOCKED'); ?></li>
                    <li><strong>Username:</strong> <?php echo e($license['buyer'] ?? 'STATIXCODE'); ?></li>
                    <li>
                        <strong>Support:</strong>
                        <?php if(($license['supported_now'] ?? 'No') === 'Yes'): ?>
                            Active until <?php echo e(\Carbon\Carbon::parse($license['supported_unil'])->toFormattedDateString()); ?>

                        <?php else: ?>
                            <span class="text-red-600 dark:text-red-400 font-semibold">NULLED - No Support</span>
                        <?php endif; ?>
                    </li>
                    <li><strong>License Code:</strong> <code><?php echo e($license['code'] ?? '—'); ?></code></li>
                </ul>
            </div>
        </div>
    </div>
<?php else: ?>
    <div class="alert-warning alert relative flex justify-between items-start gap-4 mb-4">
        <div class="flex gap-3 pr-4">
            <?php if (isset($component)) { $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c = $attributes; } ?>
<?php $component = BladeUI\Icons\Components\Svg::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('heroicon-o-exclamation-triangle'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\BladeUI\Icons\Components\Svg::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'icon mt-1.5']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $attributes = $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $component = $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
            <div class="space-y-1">
                <p class="font-semibold">
                    No valid license found.
                </p>
                <p class="text-sm">
                    Please enter your product license key to activate your installation. You can find it in your
                    <a href="https://codecanyon.net/downloads" class="underline text-inherit hover:opacity-80" target="_blank">Codecanyon Downloads</a>.
                </p>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /var/www/vhosts/projectnow.run.place/httpdocs/resources/views/filament/partials/license.blade.php ENDPATH**/ ?>